<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Usergroup extends Model
{
    use HasFactory;

    protected $table = 'usergroups';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    // Relation avec Users
    public function users()
    {
        return $this->hasMany(User::class, 'usergroup_id', 'id');
    }
}
