<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Action;
use App\Models\Programme;

class ActionSeeder extends Seeder
{
    public function run(): void
    {
        if (Programme::count() == 0) {
            $this->call(ProgrammeSeeder::class);
        }

        $actions = [
            [
                'programme_id' => Programme::where('code', 'P1')->first()->id ?? 1,
                'code' => 'A1',
                'nom' => 'Atelier de formation des cadres régionaux',
                'description' => 'Organisation d’un atelier pour renforcer les capacités administratives.',
                'prog_actif' => true,
                'prog_ouvert' => true,
            ],
            [
                'programme_id' => Programme::where('code', 'P2')->first()->id ?? 2,
                'code' => 'A2',
                'nom' => 'Campagne de sensibilisation nutritionnelle',
                'description' => 'Campagne de proximité pour améliorer les pratiques alimentaires.',
                'prog_actif' => true,
                'prog_ouvert' => false,
            ],
            [
                'programme_id' => Programme::where('code', 'P3')->first()->id ?? 3,
                'code' => 'A3',
                'nom' => 'Distribution de kits scolaires',
                'description' => 'Distribution de matériel scolaire aux enfants défavorisés.',
                'prog_actif' => true,
                'prog_ouvert' => true,
            ],
        ];

        foreach ($actions as $action) {
            Action::create($action);
        }
    }
}
