@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
      <h1>Actions</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Actions</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
            @php
				$usergroupId = Auth::user()->usergroup_id;
			@endphp
			@if(!in_array($usergroupId , [3, 5, 6]))
							  <h5 class="card-title"><a href="{{ route('actions.create') }}" class="btn btn-primary rounded-pill">
				<i class="bi bi-plus-circle"></i> Ajouter
			</a>
			</h5>
			@endif

 <br/><button onclick="exportTableToExcel('example1', 'actions.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
			
   <table id="example1" class="table table-custom">
			
					<thead class="table-dark">
						<tr>
							<th>Code & Nom</th>
							<th>Coût</th>
							<th>Programme</th>
							<th>Actif</th>
							<th>Ouvert</th>
							<th>Actions</th>
						</tr>
					</thead>
					<tbody>
						@foreach($actions as $action)
							<tr>
								<td>{{ $action->code }} : {{ $action->nom }}</td>
								<td>{{ $action->montant }}</td>
								<td>{{ $action->programme->nom ?? 'Non défini' }}</td>

								{{-- Actif --}}
								<td>
									@if(in_array(Auth::user()->usergroup_id, [3,5,6]))
										<button class="btn btn-sm-status {{ $action->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
											{{ $action->actif ? 'Oui' : 'Non' }}
										</button>
									@endif
									@if(in_array(Auth::user()->usergroup_id, [1,2,4]))
										<a href="{{ route('actions.actif', $action->id) }}" 
										   class="btn btn-sm-status {{ $action->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
											{{ $action->actif ? 'Oui' : 'Non' }}
										</a>
									@endif
								</td>

								{{-- Ouvert --}}
								<td>
									@if(in_array(Auth::user()->usergroup_id, [3,5,6]))
										<button class="btn btn-sm-status {{ $action->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
											{{ $action->ouvert ? 'Ouvert' : 'Fermé' }}
										</button>
									@endif
									@if(in_array(Auth::user()->usergroup_id, [1,2,4]))
										<a href="{{ route('actions.ouvert', $action->id) }}" 
										   class="btn btn-sm-status {{ $action->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
											{{ $action->ouvert ? 'Ouvert' : 'Fermé' }}
										</a>
									@endif
								</td>

								{{-- Actions --}}
								<td>
									<a href="{{ route('actions.show', $action->id) }}" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
									
									@if(in_array(Auth::user()->usergroup_id, [1,2,4]) && ($action->ouvert || !$action->actif))
										<a href="{{ route('actions.edit', $action->id) }}" class="btn-sm-status btn-sm-status-info">
											<i class="bi bi-pen"></i>
										</a>
										<a href="{{ route('actions.destroy', $action->id) }}"
										   class="btn btn-danger btn-sm"
										   onclick="return confirm('Supprimer cette action ?')">
											<i class="bi bi-trash"></i>
										</a>
									@endif
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>


              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
@endsection

