@extends('layouts.app')
@section('title', 'Action')

@section('content')
<div class="pagetitle">
    <h1>Détails Action</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('programmes.show', $action->programme_id) }}">Détail programme</a></li>
            <li class="breadcrumb-item active">Détails action</li>
        </ol>
    </nav>
</div>
   <div class="no-export" style="margin-bottom: 20px;">
        <button 
            class="btn btn-primary" 
            data-pdf-export="export-zone"
            data-pdf-filename="DETAIL_{{ $action->nom }}.pdf">
            📄 Exporter en PDF
        </button>
        <span class="pdf-loading">⏳ Génération en cours...</span>
    </div>
    
<section class="section" id="export-zone">
    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="mb-4">Action : <strong>{{ $action->nom }}</strong></h3>

            {{-- Message Session --}}
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ Session::get('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @php
                $usergroupId = Auth::user()->usergroup_id;
            @endphp

            {{-- Informations générales --}}
            <div class="row justify-content-start mb-4">
                <div class="col-md-9">
                    <div class="callout callout-primary p-3 border border-primary rounded">
                        <h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Code :</b> <span>{{ $action->code }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Intitulé :</b> <span>{{ $action->nom }}</span>
                            </li>
							<li class="list-group-item d-flex justify-content-between">
                                <b>Coût total :</b> <span>{{ $action->montant }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Détails :</b> <span>{{ $action->description }}</span>
                            </li>

                            {{-- Actif --}}
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <b>Action activée :</b>
                                <span>
                                    @if(in_array($usergroupId, [1,2,4]))
                                        <a href="{{ route('actions.actif', $action->id) }}" class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
                                            {{ $action->actif ? 'OUI' : 'NON' }}
                                        </a>
                                    @else
                                        <button class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
                                            {{ $action->actif ? 'OUI' : 'NON' }}
                                        </button>
                                    @endif
                                </span>
                            </li>

                            {{-- Ouvert --}}
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <b>Ouvert (en élaboration/revu) :</b>
                                <span>
                                    @if(in_array($usergroupId, [1,2,4]))
                                        <a href="{{ route('actions.ouvert', $action->id) }}" class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
                                            {{ $action->ouvert ? 'OUI' : 'NON' }}
                                        </a>
                                    @else
                                        <button class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
                                            {{ $action->ouvert ? 'OUI' : 'NON' }}
                                        </button>
                                    @endif
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
			{{-- Boutons globaux Action --}}
            @if(in_array($usergroupId, [1,2]))
            <div class="mb-4">
				@if(!$action->actif)
					<a href="{{ route('actions.actif', ['id' => $action->id, 'all' => true]) }}" class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
						{{ $action->actif ? 'Désactiver tout' : 'Activer tout' }}
					</a>
				@endif
				@if(!$action->ouvert)
					<a href="{{ route('actions.ouvert', ['id' => $action->id, 'all' => true]) }}" class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
						{{ $action->ouvert ? 'Fermer tout' : 'Ouvrir tout' }}
					</a>
				@endif
            </div>
            @endif

            {{-- Résultats --}}
            <div class="callout callout-success mb-4 p-3 border border-success rounded">
                <h5 class="mb-3 text-success"><u>Résultats de l'action</u></h5>
@if(in_array($usergroupId, [1,2,4]))
                @if($action->ouvert || !$action->actif)
                    <a href="{{ route('resultats.create', ['actionid' => $action->id]) }}" class="btn btn-primary mb-3 no-export">
                        <i class="bi bi-plus-circle"></i> Ajouter un résultat
                    </a>
                @endif
@endif

                <table class="table table-bordered table-striped">
                    <thead class="table-success text-center">
                        <tr>
                            <th>Libellé</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($action->resultats ?? [] as $resultat)
                        <tr>
                            <td>{{ $resultat->nom }}</td>
                            <td>{{ $resultat->description }}</td>
                            <td class="text-center">
                                @if($resultat->activites->isEmpty())
                                    <a href="{{ route('resultats.destroy', $resultat->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ce résultat ?')">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Activités --}}
				<div class="callout callout-danger mb-4 p-3 border border-danger rounded">
					<h5 class="mb-3 text-danger fw-bold"><u>Liste des activités par résultat</u></h5>
@if(in_array($usergroupId, [1,5,6]))
					@if($action->ouvert || !$action->actif)
						<a href="{{ route('activites.create', $action->id) }}" class="btn btn-primary mb-3 no-export">
							<i class="bi bi-plus-circle"></i> Ajouter une activité
						</a>
					@endif
@endif

					@forelse($action->resultats as $resultat)
						<div class="mb-3">
							<h6 class="text-danger fw-bold"><i class="bi bi-chevron-right"></i> Résultat : {{ $resultat->nom }}</h6>

							@if($resultat->activites->isEmpty())
								<p class="text-muted">Aucune activité pour ce résultat.</p>
							@else
								<table class="table table-bordered table-striped">
									<thead class="table-danger text-center fw-bold">
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Groupe d'activité</th>
											<th>Responsable</th>
											<th>Coût</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										@foreach($resultat->activites as $activite)
										<tr>
											<td>{{ $activite->code }}</td>
											<td>{{ $activite->nom }}</td>
											<td>{{ $activite->groupeactivite->nom ?? '-' }}</td>
											<td>{{ $activite->structureresponsable->nom ?? '-' }}</td>
											<td>{{ $activite->montant }}</td>
											<td class="text-center">
											
                        
                         @if(in_array($usergroupId, [3,4,6]))
                <button class="btn-sm-status {{ $activite->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                  {{ $activite->actif ? 'OUI' : 'NON' }}
                </button>
              @endif
              @if(in_array($usergroupId, [1,2,5]))
                	<a href="{{ route('activites.actif', $activite->id) }}" class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->actif ? 'OUI' : 'NON' }}
												</a>
              @endif
											</td>
											<td class="text-center">
												
                         @if(in_array($usergroupId, [3,4,5,6]))
                <button class="btn-sm-status {{ $activite->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                  {{ $activite->ouvert ? 'Ouvert' : 'Fermé' }}
                </button>
              @endif
              @if(in_array($usergroupId, [1,2]))
               <a href="{{ route('activites.ouvert', $activite->id) }}" class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->ouvert ? 'OUI' : 'NON' }}
												</a>
              @endif
											</td>
											<td class="text-center">
												<a href="{{ route('activites.show', $activite->id) }}" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
                      @if(in_array($usergroupId, [1,2]))
												@if(!$activite->valide)
													<a href="{{ route('activites.edit', $activite->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-pen"></i></a>
													<a href="{{ route('activites.destroy', $activite->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer cette activité ?')"><i class="bi bi-trash"></i></a>
												@endif
                      @endif
											</td>
										</tr>
										@endforeach
									</tbody>
								</table>
							@endif
						</div>
					@empty
						<p class="text-muted">Aucun résultat associé à cette action.</p>
					@endforelse
				</div>



            {{-- Structures intervenantes --}}
            <div class="callout callout-info mb-4 p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Liste des structures intervenant</u></h5>
  @if(in_array($usergroupId, [1,2,4]))
                @php
                    $canAddStructure = $action->ouvert || !$action->actif;
                @endphp
                @if($canAddStructure)
                    <a href="{{ route('structures.selecforaction', ['actionid' => $action->id, 'actionstate' => $canAddStructure]) }}" class="btn btn-primary mb-3 no-export">
                        <i class="bi bi-plus-circle"></i> Ajouter une structure
                    </a>
                @endif
  @endif

                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($action->structures ?? [] as $structure)
                        <tr>
                            <td>{{ $structure->nom }} ({{ $structure->code }})</td>
                            <td>{{ $structure->ministere->nom }} ({{ $structure->ministere->code }})</td>
                            <td>{{ $structure->pivot->datedebut }}</td>
                            <td>{{ $structure->pivot->datefin ?? 'En cours' }}</td>
                            <td class="text-center">
                                <a href="{{ route('structureactions.detach', $structure->pivot->id) }}" class="btn btn-danger btn-sm">X</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Historique des anciens intervenants --}}
            <div class="callout callout-secondary mb-4 p-3 border border-secondary rounded">
                <h5 class="mb-3 text-secondary"><u>Historique des anciens intervenants</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-secondary text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($action->structurearchives ?? [] as $structureold)
                        <tr>
                            <td>{{ $structureold->nom }} ({{ $structureold->code }})</td>
                            <td>{{ $structureold->ministere->nom }} ({{ $structureold->ministere->code }})</td>
                            <td>{{ $structureold->pivot->datedebut }}</td>
                            <td>{{ $structureold->pivot->datefin }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
@endsection
