@extends('layouts.app')

@section('title', 'Modifier une Activité')

@section('content')
<div class="pagetitle">
  <h1>Modification d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Modifier</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Modifier l’activité : <strong>{{ $activite->nom }}</strong></h5>

          <form method="POST" action="{{ route('activites.update', $activite->id) }}">
            @csrf
            @method('POST')
            <div class="row g-3">
			  <div class="col-md-6">
                <label class="form-label"><b>Groupe d'activité *</b></label>
                <select name="groupe_id" class="form-control">
                  <option value="">-- Choisir --</option>
                  @foreach($groupes as $g)
                    <option value="{{ $g->id }}" {{ $g->id == $activite->groupe_id ? 'selected' : '' }}>
                      {{ $g->nom }}
                    </option>
                  @endforeach
                </select>
              </div>
			</div>
			<div class="row g-3">
              <div class="col-md-3">
                <label class="form-label"><b>Code *</b></label>
          
                <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code"  value="{{ old('code', $activite->code) }}" required>
            @error('code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
              </div>

              <div class="col-md-9">
                <label class="form-label"><b>Nom *</b></label>
               
                  <input type="text" class="form-control @error('nom') is-invalid @enderror" id="nom" name="nom"  value="{{ old('nom', $activite->nom) }}" required>
            @error('nom')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date début *</b></label>
               
              <input type="date" class="form-control @error('datedebut') is-invalid @enderror" id="datedebut" name="datedebut"  value="{{ old('datedebut', $activite->datedebut) }}" required>
        @error('datedebut')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date fin *</b></label>
               
                             <input type="date" class="form-control @error('datefin') is-invalid @enderror" id="datefin" name="datefin"  value="{{ old('datefin', $activite->datefin) }}" required>
        @error('datefin')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Montant *</b></label>
              
                  <input type="number" class="form-control @error('montant') is-invalid @enderror" id="montant" name="montant"  value="{{ old('montant', $activite->montant) }}" required>
        @error('montant')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>
			  <div class="row g-3">
			  <div class="col-md-6">
                <label class="form-label"><b>Taux de réalisation limité à 100% ? *</b></label>
                <select name="over_taux" id="over_taux" class="form-control" required>
					<option value="">-- Choisir --</option>
					<option value="0" {{ 0 == $activite->over_taux ? 'selected' : '' }} >OUI</option>
					<option value="1" {{ 1 == $activite->over_taux ? 'selected' : '' }} >NON</option>
                </select>
              </div>
			</div>
              <div class="col-md-6">
                <label class="form-label"><b>Structure responsable *</b></label>
                <select name="structure_id" id="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($structures as $s)
                    <option value="{{ $s->id }}" {{ $s->id == $activite->structure_id ? 'selected' : '' }}>
                      {{ $s->nom }}
                    </option>
                  @endforeach
                </select>
              </div>
			@php
				$usergroupId = Auth::user()->usergroup_id;
			@endphp

@if($usergroupId != 3)
	   <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Mettre à jour</button>
				<button type="button" class="btn btn-secondary" onclick="window.history.back()">Annuler</button>
              </div>
@endif
           

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<script>
document.addEventListener('DOMContentLoaded', function () {
	const actionSelect = document.getElementById('action_id');
	const resultatSelect = document.getElementById('resultat_id');
	
	actionSelect.addEventListener('change', function () {
        const actionId = this.value;
        resultatSelect.innerHTML = '<option value="">-- Chargement... --</option>';

        if (actionId) {
            fetch(`/activites/resultats/${actionId}`)
                .then(response => response.json())
                .then(data => {
                    resultatSelect.innerHTML = '<option value="">-- Choisir un resultat --</option>';
                    data.forEach(resultat => {
                        const option = document.createElement('option');
                        option.value = resultat.id;
                        option.textContent = resultat.nom;
                        resultatSelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Erreur:', error);
                    resultatSelect.innerHTML = '<option value="">-- Erreur de chargement --</option>';
                });
        } else {
            resultatSelect.innerHTML = '<option value="">-- Choisir un resultat --</option>';
        }
    });
});
</script>
@endsection
