@extends('layouts.app')
@section('title', 'Activité')

@section('content')
<div class="pagetitle">
    <h1>Prévisions Activité</h1>
    <h5>Pour ajouter une étape, l'activité doit être modifiable (états : invalide, inactif ou ouvert)</h5>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('activites.show', $activite->id) }}">Détails Activité</a></li>
            <li class="breadcrumb-item active">Planning des prévisions</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            {{-- Message Session --}}
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ Session::get('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
 @php
                        $usergroupId = Auth::user()->usergroup_id;
                    @endphp

            <h4 class="mb-3 text-danger">Activité : <strong>{{ $activite->nom }}</strong></h4>

            {{-- Informations générales --}}
            <div class="callout mb-4 p-3 border border-danger rounded">
                <h5 class="text-danger mb-3"><u>Informations générales</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Code :</b> <span>{{ $activite->code }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Nom :</b> <span>{{ $activite->nom }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Description :</b> <span>{{ $activite->description ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Montant :</b> <span>{{ $activite->montant ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Début :</b> <span>{{ $activite->datedebut }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Fin :</b> <span>{{ $activite->datefin ?? 'En cours' }}</span></li>
                    <li class="list-group-item">
                        <b>Etat :</b>
                        <span style="color: {{ $activite->valide ? 'green' : 'red' }}; font-weight:bold;">{{ $activite->valide ? 'Validée' : 'Non validée' }}</span> |
                        <span style="color: {{ $activite->actif ? 'green' : 'red' }}; font-weight:bold;">{{ $activite->actif ? 'Activée' : 'Non activée' }}</span> |
                        <span style="color: {{ $activite->ouvert ? 'red' : 'gray' }}; font-weight:bold;">{{ $activite->ouvert ? 'Révision ou élaboration' : 'Pas de modification' }}</span>
                    </li>
                </ul>
            </div>

            {{-- Planning --}}
            <div class="callout mb-4 p-3 border border-danger rounded">
                <h4 class="text-danger mb-3"><u>Planning</u></h4>
                @php
                    $canAddPlanning = $activite->ouvert || !$activite->actif || !$activite->valide;
                    $groupedPrevisions = $activite->previsions->sortBy('dateevaluation')->groupBy(fn($item) => $item->extrant->nom ?? 'Sans extrant');
                @endphp

                @foreach($groupedPrevisions as $extrant => $previsions)
                    <h5 class="text-danger mt-3 mb-2"><u>Extrant : {{ $extrant }}</u></h5>
                    @php $extrantId = $previsions->first()->extrant->id ?? null; @endphp
@if(in_array($usergroupId, [1,2]))
                    @if($canAddPlanning)
                        <a href="{{ route('previsionactivites.create', ['activiteid' => $activite->id, 'extrantid' => $extrantId]) }}" class="btn btn-danger mb-3 rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter un Planning
                        </a>
                    @endif
@endif

                    <table class="table table-bordered table-striped">
                        <thead class="table-danger text-center">
                            <tr>
                                <th>Ordre</th>
                                <th>Date de référence</th>
                                <th>Taux</th>
                                <th>Commentaire</th>
                                <th>Outils</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($previsions as $prev)
                                @php $planning_isfree = $prev->evaluations->isEmpty(); @endphp
                                <tr>
                                    <td>{{ $prev->ordreevaluation ?? '-' }}</td>
                                    <td>{{ $prev->dateevaluation }}</td>
                                    <td>{{ $prev->niveaucible }} %</td>
                                    <td>{{ $prev->commentaire ?? '-' }}</td>
                                    <td class="text-center">
                                    @if(in_array($usergroupId, [1,2]))
                                        @if($planning_isfree)
                                            <a href="{{ route('previsionactivites.edit', $prev->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-pen"></i></a>
                                            <a href="{{ route('previsionactivites.destroy', $prev->id) }}" onclick="return confirm('Enlever cette étape de planning?')" class="btn-sm-status btn-sm-status-danger"><i class="bi bi-trash"></i></a>
                                        @endif
                                    @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endforeach
            </div>

            {{-- Bouton Évaluation --}}
            @php $canEvaluate = $evalwaitings->isNotEmpty() && $activite->valide && $activite->actif && !$activite->ouvert; @endphp
            @if($canEvaluate)
                <div class="d-flex justify-content-center mb-4">
                    <a href="{{ route('activites.evaluate', ['id' => $activite->id]) }}" class="btn btn-success rounded-pill">
                        <i class="bi bi-clipboard-check"></i> Évaluation
                    </a>
                </div>
            @endif

        </div>
    </div>
</section>
@endsection
