@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Ajouter un extrant </h2>

    {{-- Affichage des messages flash --}}
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Affichage des erreurs de validation --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Formulaire --}}
    <form action="{{ route('extrants.store') }}" method="POST">
        @csrf

        {{-- Activite ID caché --}}
        <input type="hidden" name="activite_id" value="{{ $activite_id }}">

        {{-- Nom de l'extrant --}}
        <div class="mb-3">
            <label for="nom" class="form-label">Nom de l'extrant</label>
            <input type="text" name="nom" id="nom" 
                   class="form-control @error('nom') is-invalid @enderror"
                   required value="{{ old('nom') }}">
            @error('nom')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Année --}}
        <div class="mb-3">
            <label for="annee" class="form-label">Année</label>
            <input type="number" name="annee" id="annee"
                   class="form-control @error('annee') is-invalid @enderror"
                   min="2000" max="2100"
                   required value="{{ old('annee') }}">
            <small class="form-text text-muted">
                La durée sera automatiquement du 1er janvier au 31 décembre de cette année.
            </small>
            @error('annee')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary">Enregistrer</button>
        <a href="{{ route('activites.show', $activite_id) }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>
@endsection
