@extends('layouts.app')

@section('title', 'Extrants')

@section('content')
<div class="pagetitle">
  <h1>Extrants</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Extrants</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">

              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

          <!-- Table with stripped rows -->
          <table class="table datatable">
            <thead>
              <tr>
                <th>Nom de l'Extrant</th>
                <th>Activités associées</th>
                <th>Taux d’exécution (%)</th>
                <th>Actions</th>
				 <th></th>
              </tr>
            </thead>
            <tbody>
              @foreach($extrants as $extrant)
                <tr>
                  <td>{{ $extrant->nom }}</td>
                  <td>
                    @if($extrant->activites && $extrant->activites->count() > 0)
                      <ul class="mb-0">
                        @foreach($extrant->activites as $activite)
                          <li>{{ $activite->nom }}</li>
                        @endforeach
                      </ul>
                    @else
                      <span class="text-muted">Aucune activité</span>
                    @endif
                  </td>
                  <td>
                    <span class="badge bg-info text-dark">
                      {{ number_format($extrant->taux_execution, 2) }} %
                    </span>
                  </td>
                  <td>
                    <a href="{{ route('extrants.show', $extrant->id) }}" class="btn btn-info btn-sm">
                      <i class="bi bi-eye"></i>
                    </a>
                  </td>
				  <td>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
