@extends('layouts.app')

@section('title', 'Détails de l’Extrant')

@section('content')
<div class="pagetitle">
  <h1>Détails de l’Extrant</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('extrants.index') }}">Accueil</a></li>
      <li class="breadcrumb-item active">Extrants</li>
      <li class="breadcrumb-item active">{{ $extrant->nom }}</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            Informations sur l’extrant
          </h5>

          <div class="mb-3">
            <strong>Nom :</strong> {{ $extrant->nom }}
          </div>

          @if($activite)
            <div class="mb-3">
              <strong>Activité associée :</strong> {{ $activite->nom }}
            </div>

            <div class="mb-3">
              <strong>Taux d’exécution global :</strong>
              <span class="badge bg-info text-dark">
                {{ number_format($activite->taux_execution, 2) }} %
              </span>
            </div>

            <h5 class="card-title">Étapes et Évaluations</h5>
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>Étape</th>
                  <th>Taux d’exécution (%)</th>
                  <th>Commentaire</th>
                </tr>
              </thead>
              <tbody>
                @foreach($activite->evaluations as $evaluation)
                  @if($evaluation->etape)
                    <tr>
                      <td>{{ $evaluation->etape->nom }}</td>
                      <td>{{ number_format($evaluation->etape->niveauexec * 100, 2) }}</td>
                      <td>{{ $evaluation->commentaire ?? '-' }}</td>
                    </tr>
                  @endif
                @endforeach
              </tbody>
            </table>
          @else
            <div class="alert alert-warning mt-3">
              Aucune activité associée à cet extrant.
            </div>
          @endif

          <div class="mt-4">
            <a href="{{ route('extrants.index') }}" class="btn btn-secondary">
              <i class="bi bi-arrow-left-circle"></i> Retour à la liste
            </a>
          </div>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection

