@extends('layouts.app')

@section('title', 'Ministère')

@section('content')
 <div class="pagetitle">
      <h1>Ajout du ministère</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Ministère</li>
          <li class="breadcrumb-item active">Ajout</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
	<div class="card">
    <div class="card-body">
        <h5 class="card-title">Modifier le ministère : {{ $ministere->nom }}</h5>

        <form action="{{ route('ministeres.update', $ministere->id) }}" method="POST" class="row g-3">
            @csrf
            @method('POST')

            <div class="col-md-6">
                <label for="code" class="form-label">Code *</label>
                <input type="text" class="form-control" id="code" name="code" value="{{ old('code',  $ministere->code)  }}" required>
            </div>

            <div class="col-md-6">
                <label for="nom" class="form-label">Nom du ministère *</label>
                <input type="text" class="form-control" id="nom" name="nom" value="{{ old('nom', $ministere->nom) }}" required>
            </div>

            <div class="col-12">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $ministere->description) }}</textarea>
            </div>

            <div class="text-center">
                <button type="submit" class="btn btn-primary">Mettre à jour</button>
                <a href="{{ route('ministeres.index') }}" class="btn btn-secondary">Annuler</a>
            </div>
        </form>
    </div>
</div>

        </div>
      </div>
    </section>
@endsection
