@extends('layouts.app')
@section('title', 'Type Activite')

@section('content')
 <div class="pagetitle">
    <h1>Type d'activité connu</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="{{URL::to('modeleactivites')}}">Types d'activité</a></li>
		    <li class="breadcrumb-item active">Détails</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails : <span id="details"></h5>
					@if(Session::has('status'))
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								{{Session::get('status')}}
							</div>
						</div>
					</div>
					@endif
					<div class="card-body">
						<h2>Détails : <strong> {{ $modeleactivite->nom }}</strong> </h2>
						<hr>
						<div class="row">
							<a href="{{--URL::to('pdf/'.$alertmsg->id)--}}" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Groupe  : </b> <a class="float-right"> {{$modeleactivite->groupeactivite->nom}} ({{$modeleactivite->groupeactivite->code}})</a><br>
										</li>
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  {{$modeleactivite->code}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  {{$modeleactivite->nom}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  {{$modeleactivite->description}}</a><br>
										</li>
										<li class="list-group-item">
										<b>Action activé : </b> <a class="float-right">
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $modeleactivite->is_active ? 'btn-success' : 'btn-secondary' }}" disabled>
													{{ $modeleactivite->is_active ? 'OUI' : 'NON' }}
												</button>
											@else
												 <a href="{{ route('modeleactivites.actif', $modeleactivite->id) }}" 
													class="btn btn-sm {{ $modeleactivite->is_active ? 'btn-success' : 'btn-secondary' }}">
													{{  $modeleactivite->is_active ? 'OUI' : 'NON' }}
												</a>
											@endif
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Etapes</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Ordre</th>
											<th>Désignation</th>
											<th>Ponderation</th>
											<th>Niveau d'exécution</th>
											<th>Source de vérification</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<h6 class="card-title">
											@if($nbractivites==0)
												<a href="{{ route('etapes.create', $modeleactivite->id) }}" class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une étape
												</a>
											@endif
										</h6>
										@if (!is_null($modeleactivite->etapes))
											@foreach ($modeleactivite->etapes as $etape)
											<tr>
												<td>{{ $etape->ordre }} </td>
												<td>{{ $etape->nom  }}</td>
												<td>{{ number_format($etape->ponderation, 2)  }} %</td>
												<td>{{ number_format($etape->niveauexec, 2) }} %</td>
												<td>{{ $etape->sourceverif  }}</td>
												<td>
													<a href="{{ route('etapes.edit', $etape->id) }}" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="{{ route('etapes.destroy', $etape->id) }}" class="btn btn-danger" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
												</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div><hr>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
@endsection


