@extends('layouts.app')

@section('title', 'Partenaire')

@section('content')
 <div class="pagetitle">
      <h1>Ajout du partenaire</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Partenaire</li>
          <li class="breadcrumb-item active">Ajout</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
     <div class="card">
  <div class="card-body">
    <h5 class="card-title">Ajouter un partenaire</h5>

    <form method="POST" action="{{ route('partenaires.store') }}">
      @csrf

      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Code *</label>
          <input type="text" name="code" class="form-control" required>
        </div>

        <div class="col-md-8">
          <label class="form-label">Nom *</label>
          <input type="text" name="nom" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Type de partenaire *</label>
          <select name="typepartenaire_id" class="form-select" required>
            <option value="">Sélectionner...</option>
            @foreach($types as $t)
              <option value="{{ $t->id }}">{{ $t->type }}</option>
            @endforeach
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="desctiption" class="form-control"></textarea>
        </div>
      </div>

      <div class="mt-3">
        <button type="submit" class="btn btn-success">Enregistrer</button>
        <a href="{{ route('partenaires.index') }}" class="btn btn-secondary">Annuler</a>
      </div>
    </form>
  </div>
</div>

        </div>
      </div>
    </section>
@endsection
