@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Ajouter une prévision pour l'activité #{{ $activiteid }}</h2>

    {{-- Affichage des messages flash --}}
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Affichage des erreurs de validation --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Formulaire --}}
    <form action="{{ route('previsionactivites.store') }}" method="POST">
        @csrf

        <input type="hidden" name="activite_id" value="{{ $activiteid }}">
        <input type="hidden" name="extrant_id" value="{{ $extrant->id }}">
        <input type="hidden" name="ordreevaluation" value="{{ old('ordreevaluation', $nextOrdre) }}">

        <input type="text" class="form-control mb-3" value="{{ $extrant->nom}}" disabled>

        <div class="mb-3">
            <label for="niveaucible" class="form-label">Niveau cible (%)</label>
            <input type="number" name="niveaucible" id="niveaucible"
                   class="form-control @error('niveaucible') is-invalid @enderror" 
                   step="0.01" min="0" max="100" required
                   value="{{ old('niveaucible') }}">
            @error('niveaucible')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="dateevaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="dateevaluation" id="dateevaluation"
                   class="form-control @error('dateevaluation') is-invalid @enderror"
                   required value="{{ old('dateevaluation') }}">
            @error('dateevaluation')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary">Enregistrer</button>
        <a href="{{ route('activites.planning', $activiteid) }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>

{{-- JS pour verrouiller la valeur côté client --}}
<script>
document.addEventListener('DOMContentLoaded', function() {
    const input = document.getElementById('niveaucible');
    input.addEventListener('input', function() {
        let val = parseFloat(this.value);
        if (val > 100) this.value = 100;
        else if (val < 0) this.value = 0;
    });
});
</script>
@endsection
