@extends('layouts.app')

@section('title', 'Modifier une Activité')

@section('content')
<div class="pagetitle">
  <h1>Modification d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Modifier</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Modifier l’activité : <strong>{{ $activite->nom }}</strong></h5>

          <form method="POST" action="{{ route('activites.update', $activite->id) }}">
            @csrf
            @method('POST')
            <div class="row g-3">

              <div class="col-md-3">
                <label class="form-label">Code</label>
                <input type="text" name="code" class="form-control" value="{{ old('code', $activite->code) }}" required>
              </div>

              <div class="col-md-9">
                <label class="form-label">Nom</label>
                <input type="text" name="nom" class="form-control" value="{{ old('nom', $activite->nom) }}" required>
              </div>

              <div class="col-md-4">
                <label class="form-label">Date début</label>
                <input type="date" name="datedebut" class="form-control" value="{{ old('datedebut', $activite->datedebut) }}" required>
              </div>

              <div class="col-md-4">
                <label class="form-label">Date fin</label>
                <input type="date" name="datefin" class="form-control" value="{{ old('datefin', $activite->datefin) }}" required>
              </div>

              <div class="col-md-4">
                <label class="form-label">Montant</label>
                <input type="number" step="0.001" name="montant" class="form-control" value="{{ old('montant', $activite->montant) }}" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Structure</label>
                <select name="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($structures as $s)
                    <option value="{{ $s->id }}" {{ $s->id == $activite->structure_id ? 'selected' : '' }}>
                      {{ $s->nom }}
                    </option>
                  @endforeach
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label">Action</label>
                <select name="action_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($actions as $a)
                    <option value="{{ $a->id }}" {{ $a->id == $activite->action_id ? 'selected' : '' }}>
                      {{ $a->nom }}
                    </option>
                  @endforeach
                </select>
              </div>
@php
    $usergroupId = Auth::user()->usergroup_id;
@endphp
@if($usergroupId != 3)
	   <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Mettre à jour</button>
<button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>
@endif
           

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
@endsection
