@extends('layouts.app')

@section('title', 'Structure')

@section('content')
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Ajouter une structure</h5>

    <form method="POST" action="{{ route('structures.store') }}">
      @csrf

      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Code *</label>
          <input type="text" name="code" class="form-control" value="{{ old('code') }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Nom *</label>
          <input type="text" name="nom" class="form-control" value="{{ old('nom') }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Ministère *</label>
          <select name="ministere_id" class="form-select" required>
            <option value="">Sélectionner...</option>
            @foreach($ministeres as $m)
              <option value="{{ $m->id }}" {{ old('ministere_id') == $m->id ? 'selected' : '' }}>
                {{ $m->nom }}
              </option>
            @endforeach
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control">{{ old('description') }}</textarea>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-primary">Enregistrer</button>
 <button type="reset" class="btn btn-secondary">Réinitialiser</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
