@extends('layouts.app')

@section('title', 'Ministère')

@section('content')
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Modifier la structure</h5>

    <form method="POST" action="{{ route('structures.update', $structure->id) }}">
      @csrf
      @method('POST')

      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Code *</label>
          <input type="text" name="code" class="form-control" value="{{ old('code', $structure->code) }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Nom *</label>
          <input type="text" name="nom" class="form-control" value="{{ old('nom', $structure->nom) }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Ministère *</label>
          <select name="ministere_id" class="form-select" required>
            <option value="">Sélectionner...</option>
            @foreach($ministeres as $m)
              <option value="{{ $m->id }}" {{ old('ministere_id', $structure->ministere_id) == $m->id ? 'selected' : '' }}>
                {{ $m->nom }}
              </option>
            @endforeach
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control">{{ old('description', $structure->description) }}</textarea>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-primary">Mettre à jour</button>
          <a href="{{ route('structures.index') }}" class="btn btn-secondary">Annuler</a>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
