@extends('layouts.app')

@section('title', 'Groupes d\'utilisateurs')

@section('content')
 <div class="pagetitle">
      <h1>Modification d'un groupe d’utilisateur</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
          <li class="breadcrumb-item">Groupes d’utilisateurs</li>
          <li class="breadcrumb-item active">Modification</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Modifier le groupe d’utilisateur</h5>

              <form method="POST" action="{{ route('usergroups.update', $usergroup->id) }}">
                @csrf
                @method('POST')

                <div class="row g-3">
                  
                  <div class="col-md-6">
                    <label class="form-label">Code *</label>
                    <input type="text" name="code" class="form-control @error('code') is-invalid @enderror" 
                           value="{{ old('code', $usergroup->code) }}" maxlength="10" required>
                    @error('code')
                      <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Nom du groupe *</label>
                    <input type="text" name="nom" class="form-control @error('nom') is-invalid @enderror" 
                           value="{{ old('nom', $usergroup->nom) }}" maxlength="30" required>
                    @error('nom')
                      <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Description</label>
                    <input type="text" name="description" class="form-control @error('description') is-invalid @enderror" 
                           value="{{ old('description', $usergroup->description) }}">
                    @error('description')
                      <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                  </div>

                  <div class="text-center">
                    <button type="submit" class="btn btn-success">Mettre à jour</button>
                    <a href="{{ route('usergroups.index') }}" class="btn btn-secondary">Annuler</a>
                  </div>
                </div>
              </form>

            </div>
          </div>
        </div>
      </div>
    </section>
@endsection
