<?php $__env->startSection('title', 'Accueil'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
      <h1>Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
	  

      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">

           

        

          
 <div class="row">

    <!-- Structures en retard -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Structures ayant dépassé leur délai d’évaluation ( <?php echo e($nombreStructuresEnRetard); ?>)</h5>
            <button onclick="exportTableToExcel('delai-evacuation-depasse-table', 'structure_delai_evacuation_depasse.xlsx', {includeColumns: [0,1,2,3,4]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>
      <table class="table datatable" id="delai-evacuation-depasse-table">
    <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Date limite (date_reference)</th>
            <th>Date réelle (date_evaluation)</th>
            <th>Retard (jours)</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $structuresEnRetard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $structure->activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $activite->evaluations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evaluation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($structure->nom); ?></td>
                        <td><?php echo e($activite->nom ?? $activite->code); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($evaluation->date_reference)->toDateString()); ?></td>
                        <td>
                            <?php if($evaluation->date_evaluation): ?>
                                <?php echo e(\Carbon\Carbon::parse($evaluation->date_evaluation)->toDateString()); ?>

                            <?php else: ?>
                                <span class="text-danger">Non évalué</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                                $ref = \Carbon\Carbon::parse($evaluation->date_reference);
                                $eval = $evaluation->date_evaluation
                                        ? \Carbon\Carbon::parse($evaluation->date_evaluation)
                                        : \Carbon\Carbon::today();
                                $jours = $eval->diffInDays($ref, false);
                            ?>
                            <?php echo e($jours); ?> j
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

        </div>
      </div>
    </div>

    <!-- Top 10 meilleurs taux -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des meilleurs taux d’exécution</h5>
             <button onclick="exportTableToExcel('meilleur-taux-execution-table', 'meilleur_taux_execution.xlsx', {includeColumns: [0,1,2,3,4]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>
    <table class="table datatable" id="meilleur-taux-execution-table">
      <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Taux Prévision (%)</th>
            <th>Taux Réalisation (%)</th>
            <th>Écart (%)</th>
        </tr>
    </thead>
    <tbody>
            <?php $__currentLoopData = $topStructures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evaluation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          

            <tr>
                <td><?php echo e($evaluation->structure); ?></td>
                <td><?php echo e($evaluation->activite); ?></td>
                <td><?php echo e(number_format($evaluation->taux_prevision, 2)); ?></td>
                <td><?php echo e(number_format($evaluation->taux_realisation, 2)); ?></td>
                <td>
                
                <?php if($evaluation->ecart < 5): ?> 
                   <span style="background-color:#d4edda !important; color:#155724 !important; display:inline-block !important;"
>
                   
													<?php echo e(number_format($evaluation->ecart, 2)); ?>%
												</span>
                 <?php elseif($evaluation->ecart < 15): ?> 
                     <span style="background-color:#a9dfbf !important; color:#155724 !important; display:inline-block !important;">
                     

													<?php echo e(number_format($evaluation->ecart, 2)); ?>%
												</span>
                 <?php else: ?> {
                     <span  style="background-color:#28a745 !important; color:#155724 !important; display:inline-block !important;">
                    
													<?php echo e(number_format($evaluation->ecart, 2)); ?>%
												</span>
                
           
                <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

        </div>
      </div>
    </div>

   <!-- Top 10 faibles taux -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des taux les plus faibles</h5>
          <button onclick="exportTableToExcel('taux-faible-table', 'taux_faible.xlsx', {includeColumns: [0,1,2,3,4]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>
    <table class="table datatable" id="taux-faible-table"> 
      <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Taux Prévision (%)</th>
            <th>Taux Réalisation (%)</th>
            <th>Écart (%)</th>
        </tr>
    </thead>
    <tbody>
            <?php $__currentLoopData = $lowStructures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evaluation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          

            <tr>
                <td><?php echo e($evaluation->structure); ?></td>
                <td><?php echo e($evaluation->activite); ?></td>
                <td><?php echo e(number_format($evaluation->taux_prevision, 2)); ?></td>
                <td><?php echo e(number_format($evaluation->taux_realisation, 2)); ?></td>
                <td>
                
                  <?php if($evaluation->ecart > -5): ?>
        <span style="background-color:#f8d7da !important; color:#721c24 !important; display:inline-block !important;">
            <?php echo e(number_format($evaluation->ecart, 2)); ?>%
        </span>
    <?php elseif($evaluation->ecart > -15): ?>
        <span style="background-color:#f1aeb5 !important; color:#721c24 !important; display:inline-block !important;">
            <?php echo e(number_format($evaluation->ecart, 2)); ?>%
        </span>
    <?php else: ?>
        <span style="background-color:#dc3545 !important; color:white !important; display:inline-block !important;">
            <?php echo e(number_format($evaluation->ecart, 2)); ?>%
        </span>
    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

        </div>
      </div>
    </div>
<!-- Graphique -->
    <div class="col-lg-12">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Taux moyens par programme</h5>
            <canvas id="tauxChart"></canvas>
        </div>
    </div>
</div>

  </div>
         
            <!-- Recent Sales -->
			
			
            
			
			
			

        

          </div>
        </div><!-- End Left side columns -->

    

      </div>
    </section>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('tauxChart');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($tauxParProgramme->pluck('nom')); ?>,
        datasets: [{
            label: 'Taux moyen (%)',
            data: <?php echo json_encode($tauxParProgramme->pluck('taux_moyen')); ?>,
            borderWidth: 2,
            borderColor: 'rgba(54, 162, 235, 1)',
            backgroundColor: 'rgba(54, 162, 235, 0.3)',
            fill: true,
            tension: 0.4
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true,
                suggestedMax: 120
            }
        } 
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/welcome.blade.php ENDPATH**/ ?>