<?php $__env->startSection('title', 'Groupe Activite'); ?>

<?php $__env->startSection('content'); ?>
 <div class="pagetitle">
    <h1>Groupe d'activité connu</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="<?php echo e(URL::to('groupeactivites')); ?>">Groupe d'activité</a></li>
		    <li class="breadcrumb-item active">Détails</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails : <span id="details"></h5>
					<?php if(Session::has('status')): ?>
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								<?php echo e(Session::get('status')); ?>

							</div>
						</div>
					</div>
					<?php endif; ?>
					<div class="card-body">
						<h2>Détails : <strong> <?php echo e($groupeactivite->nom); ?></strong> </h2>
						<hr>
						<div class="row">
							<a href="" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  <?php echo e($groupeactivite->code); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  <?php echo e($groupeactivite->nom); ?></a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  <?php echo e($groupeactivite->description); ?></a><br>
										</li>
										<li class="list-group-item">
										<b>Action activé : </b> <a class="float-right">
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($groupeactivite->is_active ? 'btn-success' : 'btn-secondary'); ?>" disabled>
													<?php echo e($groupeactivite->is_active ? 'OUI' : 'NON'); ?>

												</button>
											<?php else: ?>
												 <a href="<?php echo e(route('groupeactivites.actif', $groupeactivite->id)); ?>" 
													class="btn btn-sm <?php echo e($groupeactivite->is_active ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($groupeactivite->is_active ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Etapes</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Ordre</th>
											<th>Désignation</th>
											<th>Ponderation</th>
											<th>Niveau d'exécution</th>
											<th>Source de vérification</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<h6 class="card-title">
											<?php if($nbractivites==0): ?>
												<a href="<?php echo e(route('etapes.create', $groupeactivite->id)); ?>" class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une étape
												</a>
											<?php endif; ?>
										</h6>
										<?php if(!is_null($groupeactivite->etapes)): ?>
											<?php $__currentLoopData = $groupeactivite->etapes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $etape): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($etape->ordre); ?> </td>
												<td><?php echo e($etape->nom); ?></td>
												<td><?php echo e(number_format($etape->ponderation, 2)); ?> %</td>
												<td><?php echo e(number_format($etape->niveauexec, 2)); ?> %</td>
												<td><?php echo e($etape->sourceverif); ?></td>
												<td>
													<a href="<?php echo e(route('etapes.edit', $etape->id)); ?>" class="btn-sm-status btn-sm-status-info"><i class="bi bi-pen"></i></a>
	<?php if($loop->last): ?>											
	<a href="<?php echo e(route('etapes.destroy', $etape->id)); ?>" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
	<?php endif; ?>											</td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div><hr>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/groupeactivites/show.blade.php ENDPATH**/ ?>