<?php $__env->startSection('title', 'Groupe Utilisateurs'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Groupes Utilisateurs</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Groupes d utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="<?php echo e(route('usergroups.create')); ?>" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

           <button onclick="exportTableToExcel('example1', 'groupe_utilisateur.xlsx', {includeColumns: [0,1]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>

          <table id="example1" class="table table-custom">
            <thead>
              <tr>
               <th>id</th>
                <th>Nom</th>
                <th>Description</th>
               
                <th></th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $usergroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
               <td><?php echo e($group->id); ?></td>
                <td><?php echo e($group->nom); ?></td>
                <td><?php echo e($group->description); ?></td>
                
                <td></td>
                <td>
                  <a href="<?php echo e(route('usergroups.edit', $group->id)); ?>" class="btn-sm-status btn-sm-status-info">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="<?php echo e(route('usergroups.destroy', $group->id)); ?>"
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer ce groupe ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/usergroups/index.blade.php ENDPATH**/ ?>