<?php

namespace App\Http\Controllers;

use App\Models\Usergroup;
use Illuminate\Http\Request;

class UsergroupsController extends Controller
{
    public function index() { 	
/*$usergroups  = Usergroup::all();
    return view('usergroups.index', compact('usergroups')); */
    
     try {
            $usergroups = Usergroup::all();
            return view('usergroups.index', compact('usergroups'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des groupes utilisateurs : ' . $e->getMessage());
        }
    }
    public function show($id) { 	
	return UserGroup::findOrFail($id); 
  
  }

public function create()
    {
        //return view('usergroups.create');
        
         try {
            return view('usergroups.create');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire : ' . $e->getMessage());
        }
    }
    public function store(Request $request)
    {
      $validated = $request->validate([
            'code' => 'required|string|max:10|unique:usergroups,code',
            'nom' => 'required|string|max:30|unique:usergroups,nom',
            'description' => 'nullable|string',
        ]);
        /*UserGroup::create($data);
	return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur créé avec succès.');*/
  
  

        try {
            $usergroup = new Usergroup($validated);
            if ($usergroup->save()) {
                return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur créé avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la création du groupe utilisateur.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la création du groupe utilisateur : ' . $e->getMessage());
        }
    }
 public function edit($id)
    {
	/*$usergroup = Usergroup::findOrFail($id);
        return view('usergroups.edit', compact('usergroup'));*/
        try {
            $usergroup = Usergroup::findOrFail($id);
            return view('usergroups.edit', compact('usergroup'));
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('usergroups.index')->with('error', 'Groupe utilisateur introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }
    public function update(Request $request, $id)
    {
         $usergroup = Usergroup::findOrFail($id);

            $validated = $request->validate([
                'code' => 'sometimes|string|max:10|unique:usergroups,code,' . $usergroup->id,
                'nom' => 'sometimes|string|max:30|unique:usergroups,nom,' . $usergroup->id,
                'description' => 'nullable|string',
            ]);
        /*$ug->update($data);
         return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur mis à jour avec succès.');*/
         
          try {
          

            if ($usergroup->update($validated)) {
                return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du groupe utilisateur.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('usergroups.index')->with('error', 'Groupe utilisateur introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour : ' . $e->getMessage());
        }
    }

    public function destroy($id) { 
	/*UserGroup::findOrFail($id)->delete(); 
        return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur supprimé avec succès.');*/
        try {
            $usergroup = Usergroup::findOrFail($id);
            if ($usergroup->delete()) {
                return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur supprimé avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression du groupe utilisateur.');
            }
            
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('usergroups.index')->with('error', 'Groupe utilisateur introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la suppression : ' . $e->getMessage());
        }
 }
}

