@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
    <h1>CSDs</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">CSDs</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="{{ route('csds.create') }}" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                    <button onclick="exportTableToExcel('example1', 'cadre_sectoriel.xlsx', {includeColumns: [0,1,2]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>
                  
                     <table id="example1" class="table table-custom">
                        <thead>
                            <tr>
                                <th style="min-width: 100px;">Code</th>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Editer</th>
                                <th>Supprimer</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($csds as $csd)
                                <tr>
                                    <td>{{ $csd->code }}</td>
                                    <td>{{ $csd->nom }}</td>
                                    <td>{{ $csd->description }}</td>
                                    <td>
                                        <a href="{{ route('csds.edit', $csd->id) }}" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-pen"></i>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('csds.destroy', $csd->id) }}" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer ce CSD ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
