@extends('layouts.app')

@section('title', 'Modification Étape')

@section('content')
<div class="pagetitle">
    <h1>Modification d'une étape</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item">Accueil</a></li>
            <li class="breadcrumb-item">Modèle Activité</li>
            <li class="breadcrumb-item active">Modification</li>
        </ol>
    </nav>
</div><!-- End Page Title -->

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Modifier l'étape</h5>

                    <form method="POST" action="{{ route('etapes.update', $etape->id) }}">
                        @csrf
                        @method('POST') 
                        <input type="hidden" name="groupeactivite_id" value="{{ $etape->groupeactivite_id }}">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Ordre</label>
                                <input type="number" name="ordre" class="form-control" value="{{ old('ordre', $etape->ordre) }}" required step="1" readonly>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Désignation</label>
                                <input type="text" name="nom" class="form-control" value="{{ old('nom', $etape->nom) }}" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><b>Pondération</b></label>
                                <input type="number" id="ponderation" name="ponderation" class="form-control" value="{{ old('ponderation', $etape->ponderation ?? 0.01) }}" step="0.01" min="0.01" pattern="\d*" onkeypress="return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46">
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><b>Niveau d'exécution</b></label>
                                <input type="number" id="niveauexec" name="niveauexec" class="form-control" value="{{ $sommeExistante ?? 0 }}" readonly step="0.01">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Source de vérification</label>
                                <textarea name="sourceverif" class="form-control">{{ old('sourceverif', $etape->sourceverif) }}</textarea>
                            </div>
                        </div>

                        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                        <script>
                        $(document).ready(function() {
                            let sommeExistante = {{ $sommeExistante ?? 0 }};
                            $('#niveauexec').val((sommeExistante + parseFloat($('#ponderation').val())).toFixed(2));

                            $('#ponderation').on('blur', function() {
                                let nouvellePonderation = parseFloat($(this).val()) || 0;

                                if(nouvellePonderation <= 0) {
                                    alert('La pondération doit être strictement supérieure à 0 !');
                                    $(this).val('0.01');
                                    nouvellePonderation = 0.01;
                                }

                                let niveau = sommeExistante + nouvellePonderation;

                                if (niveau > 100) {
                                    niveau = 100;
                                    $(this).val((100 - sommeExistante).toFixed(2));
                                    alert('La somme des pondérations ne peut pas dépasser 100 !');
                                }

                                $('#niveauexec').val(niveau.toFixed(2));
                            });
                        });
                        </script>

                        <div class="mt-3">
                            <button type="submit" class="btn btn-success">Enregistrer les modifications</button>
                            <a href="{{ route('etapes.index') }}" class="btn btn-secondary">Annuler</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</section>
@endsection
