@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
      <h1>Structures</h1>
      <nav>
        <ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="">Acceuil</a></li>
			<a href="{{ route('activites.show', $activiteid) }}"> Activite </a>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <!-- Table with stripped rows -->
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>Structure</th>
                    <th>Ministère</th>
                    <th>Action</th>
                   <th></th>
                  </tr>
                </thead>
                <tbody>
				@foreach($structures as $structure)
				<tr>
                    <td>{{ $structure->code }} : {{ $structure->nom }}</td>
                    <td>{{ $structure->ministere->code }} : {{ $structure->ministere->nom }}</td>
                    <td>
                        <a href="{{ route('structureactivites.attach', ['structureid' => $structure->id,'activiteid' => $activiteid, 'activitestate' => $activestate]) }}" class="btn btn-info">
							<i class="bi bi-plus"></i>
						</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
  </table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
@endsection
