@extends('layouts.app')

@section('title', 'Structures')

@section('content')
<div class="pagetitle">
  <h1>Structures</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Structures</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="{{ route('structures.create') }}" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

          <button onclick="exportTableToExcel('example1', 'structures.xlsx', {includeColumns: [0,1]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>

           <table id="example1" class="table table-custom">
            <thead>
              <tr>
                <th>Code</th>
                <th>Nom</th>
                <th>Description</th>
                <th>Ministère</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($structures as $structure)
              <tr>
                <td>{{ $structure->code }}</td>
                <td>{{ $structure->nom }}</td>
                <td>{{ $structure->description }}</td>
                <td>{{ $structure->ministere ? $structure->ministere->nom : 'Non défini' }}</td>
                <td>
					<a href="{{ route('structures.show', $structure->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
                  <a href="{{ route('structures.edit', $structure->id) }}" class="btn-sm-status btn-sm-status-info">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="{{ route('structures.destroy', $structure->id) }}" 
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer cette structure ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
