@extends('layouts.app')

@section('title', 'Type de partenaires')

@section('content')
<div class="pagetitle">
  <h1>Type de partenaires</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Types de partenaires</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="{{ route('typepartenaires.create') }}" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

            <button onclick="exportTableToExcel('example1', 'type_partenaires.xlsx', {includeColumns: [1,2]})" 
        class="btn btn-success">
            Exporter en Excel
            </button>

         <table id="example1" class="table table-custom">
            <thead>
              <tr>
                <th>#</th>
                <th>Type</th>
                <th>Description</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($typepartenaires as $typepartenaire)
              <tr>
                <td></td>
                <td>{{ $typepartenaire->type }}</td>
                <td>{{ $typepartenaire->description }}</td>
                <td>
                  <a href="{{ route('typepartenaires.edit', $typepartenaire->id) }}" class="btn-sm-status btn-sm-status-info">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="{{ route('typepartenaires.destroy', $typepartenaire->id) }}" 
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer ce type ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
